#[=======================================================================[.rst:
Findfelix-drivers
-------------

Finds the felix-drivers library.

Imported Targets
^^^^^^^^^^^^^^^^

This module provides the following imported targets, if found:

``felix-drivers::felix-drivers``
  The felix-drivers library (all bundled together)
``felix-drivers::DFDebug``
  The DFDebug library
``felix-drivers::cmdline``
  The cmdline library
``felix-drivers::cmem_rcc``
  The cmem_rcc library
``felix-drivers::getinput``
  The getinput library
``felix-drivers::io_rcc``
  The io_rcc library
``felix-drivers::rcc_error``
  The rcc_error library

Result Variables
^^^^^^^^^^^^^^^^

This will define the following variables:

``felix-drivers_FOUND``
  True if the system has the felix-drivers library.
``felix-drivers_VERSION``
  The version of the felix-drivers library which was found.

#]=======================================================================]

find_path(felix-drivers_INCLUDE_DIR
  NAMES flxcard/flx_common.h
  PATHS ${felix-drivers_ROOT}/include
  PATH_SUFFIXES felix-drivers
  NO_CACHE
)
find_library(felix-drivers_DFDebug_LIBRARY
  NAMES DFDebug
  PATHS ${felix-drivers_ROOT}/lib
  NO_CACHE
)
find_library(felix-drivers_cmdline_LIBRARY
  NAMES cmdline
  PATHS ${felix-drivers_ROOT}/lib
  NO_CACHE
)
find_library(felix-drivers_cmem_rcc_LIBRARY
  NAMES cmem_rcc
  PATHS ${felix-drivers_ROOT}/lib
  NO_CACHE
)
find_library(felix-drivers_getinput_LIBRARY
  NAMES getinput
  PATHS ${felix-drivers_ROOT}/lib
  NO_CACHE
)
find_library(felix-drivers_io_rcc_LIBRARY
  NAMES io_rcc
  PATHS ${felix-drivers_ROOT}/lib
  NO_CACHE
)
find_library(felix-drivers_rcc_error_LIBRARY
  NAMES rcc_error
  PATHS ${felix-drivers_ROOT}/lib
  NO_CACHE
)

# Example approach: parse the tail of felix-drivers_ROOT
# e.g. /path/to/felix_drivers/V1.2.3/x86_64 => felix-drivers_VERSION = V1.2.3
if(felix-drivers_ROOT)
  string(REGEX REPLACE "^.*/([^/]+)/[^/]+$" "\\1" felix-drivers_VERSION "${felix-drivers_ROOT}")
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(felix-drivers
  FOUND_VAR felix-drivers_FOUND
  REQUIRED_VARS
    felix-drivers_DFDebug_LIBRARY
    felix-drivers_cmdline_LIBRARY
    felix-drivers_cmem_rcc_LIBRARY
    felix-drivers_getinput_LIBRARY
    felix-drivers_io_rcc_LIBRARY
    felix-drivers_rcc_error_LIBRARY
    felix-drivers_INCLUDE_DIR
  VERSION_VAR felix-drivers_VERSION
)

if(felix-drivers_FOUND AND NOT TARGET felix-drivers::DFDebug)
  add_library(felix-drivers::DFDebug UNKNOWN IMPORTED)
  set_target_properties(felix-drivers::DFDebug PROPERTIES
    IMPORTED_LOCATION "${felix-drivers_DFDebug_LIBRARY}"
    INTERFACE_INCLUDE_DIRECTORIES "${felix-drivers_INCLUDE_DIR}"
  )
endif()

if(felix-drivers_FOUND AND NOT TARGET felix-drivers::cmdline)
  add_library(felix-drivers::cmdline UNKNOWN IMPORTED)
  set_target_properties(felix-drivers::cmdline PROPERTIES
    IMPORTED_LOCATION "${felix-drivers_cmdline_LIBRARY}"
    INTERFACE_INCLUDE_DIRECTORIES "${felix-drivers_INCLUDE_DIR}"
  )
endif()

if(felix-drivers_FOUND AND NOT TARGET felix-drivers::cmem_rcc)
  add_library(felix-drivers::cmem_rcc UNKNOWN IMPORTED)
  set_target_properties(felix-drivers::cmem_rcc PROPERTIES
    IMPORTED_LOCATION "${felix-drivers_cmem_rcc_LIBRARY}"
    INTERFACE_INCLUDE_DIRECTORIES "${felix-drivers_INCLUDE_DIR}"
  )
endif()

if(felix-drivers_FOUND AND NOT TARGET felix-drivers::getinput)
  add_library(felix-drivers::getinput UNKNOWN IMPORTED)
  set_target_properties(felix-drivers::getinput PROPERTIES
    IMPORTED_LOCATION "${felix-drivers_getinput_LIBRARY}"
    INTERFACE_INCLUDE_DIRECTORIES "${felix-drivers_INCLUDE_DIR}"
  )
endif()

if(felix-drivers_FOUND AND NOT TARGET felix-drivers::io_rcc)
  add_library(felix-drivers::io_rcc UNKNOWN IMPORTED)
  set_target_properties(felix-drivers::io_rcc PROPERTIES
    IMPORTED_LOCATION "${felix-drivers_iorcc_LIBRARY}"
    INTERFACE_INCLUDE_DIRECTORIES "${felix-drivers_INCLUDE_DIR}"
  )
endif()

if(felix-drivers_FOUND AND NOT TARGET felix-drivers::rcc_error)
  add_library(felix-drivers::rcc_error UNKNOWN IMPORTED)
  set_target_properties(felix-drivers::rcc_error PROPERTIES
    IMPORTED_LOCATION "${felix-drivers_rcc_error_LIBRARY}"
    INTERFACE_INCLUDE_DIRECTORIES "${felix-drivers_INCLUDE_DIR}"
  )
endif()

if(felix-drivers_FOUND AND NOT TARGET felix-drivers::felix-drivers)
  add_library(felix-drivers::felix-drivers INTERFACE IMPORTED)
  set_property(TARGET felix-drivers::felix-drivers PROPERTY
    INTERFACE_LINK_LIBRARIES
      felix-drivers::DFDebug
      felix-drivers::cmdline
      felix-drivers::cmem_rcc
      felix-drivers::getinput
      felix-drivers::io_rcc
      felix-drivers::rcc_error
  )
endif()