#[=======================================================================[.rst:
Findfreetype
------------

Finds the freetype library.

Imported Targets
^^^^^^^^^^^^^^^^

This module provides the following imported targets, if found:

``freetype::freetype``
  The freetype library

Result Variables
^^^^^^^^^^^^^^^^

This will define the following variables:

``freetype_FOUND``
  True if the system has the freetype library.
``freetype_VERSION``
  The version of the freetype library which was found.

#]=======================================================================]

find_package(PkgConfig REQUIRED)

pkg_check_modules(PC_freetype2 QUIET freetype2)

find_path(freetype_INCLUDE_DIR
  NAMES freetype/freetype.h
  PATHS ${PC_freetype2_INCLUDE_DIRS}
  PATH_SUFFIXES freetype2
  NO_CACHE
)
find_library(freetype_LIBRARY
  NAMES freetype
  PATHS ${PC_freetype2_LIBRARY_DIRS}
  NO_CACHE
)

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(freetype
  FOUND_VAR freetype_FOUND
  REQUIRED_VARS freetype_LIBRARY freetype_INCLUDE_DIR
  VERSION_VAR freetype_VERSION
)

if(freetype_FOUND AND NOT TARGET freetype::freetype)
  add_library(freetype::freetype SHARED IMPORTED)
  set_target_properties(freetype::freetype PROPERTIES
    IMPORTED_LOCATION "${freetype_LIBRARY}"
    INTERFACE_INCLUDE_DIRECTORIES "${freetype_INCLUDE_DIR}"
  )
endif()