#[=======================================================================[.rst:
Findlibnuma
-------------

Finds the libnuma library.

Imported Targets
^^^^^^^^^^^^^^^^

This module provides the following imported targets, if found:

``libnuma::libnuma``
  The libnuma library

Result Variables
^^^^^^^^^^^^^^^^

This will define the following variables:

``libnuma_FOUND``
  True if the system has the libnuma library.
``libnuma_VERSION``
  The version of the libnuma library which was found.

#]=======================================================================]

find_path(libnuma_INCLUDE_DIR
  NAMES numa.h
  PATHS ${libnuma_ROOT}/include
  PATH_SUFFIXES numa
  NO_CACHE
)
find_library(libnuma_LIBRARY
  NAMES numa
  PATHS ${libnuma_ROOT}/lib
  NO_CACHE
)

find_package(PkgConfig)
if(PKG_CONFIG_FOUND)
  set(ENV{PKG_CONFIG_PATH} "${libnuma_ROOT}/lib/pkgconfig:$ENV{PKG_CONFIG_PATH}")
  pkg_check_modules(PKG_LIBNUMA numa QUIET)
  if(PKG_LIBNUMA_FOUND)
    set(libnuma_VERSION "${PKG_LIBNUMA_VERSION}")
  endif()
endif()

# If not found via pkg-config, derive from the libnuma_ROOT path or any fallback
if(NOT libnuma_VERSION)
  # Example approach: parse the tail of libnuma_ROOT
  # e.g. /path/to/libnuma/V1.2.3/x86_64 => libnuma_VERSION = V1.2.3
  if(libnuma_ROOT)
    string(REGEX REPLACE "^.*/([^/]+)/[^/]+$" "\\1" libnuma_VERSION "${libnuma_ROOT}")
  endif()
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(libnuma
  FOUND_VAR libnuma_FOUND
  REQUIRED_VARS libnuma_LIBRARY libnuma_INCLUDE_DIR
  VERSION_VAR libnuma_VERSION
)

if(libnuma_FOUND AND NOT TARGET libnuma::libnuma)
  add_library(libnuma::libnuma UNKNOWN IMPORTED)
  set_target_properties(libnuma::libnuma PROPERTIES
    IMPORTED_LOCATION "${libnuma_LIBRARY}"
    INTERFACE_INCLUDE_DIRECTORIES "${libnuma_INCLUDE_DIR}"
  )
endif()