#[=======================================================================[.rst:
Findpybind11
-------------

Finds the pybind11 library.

Imported Targets
^^^^^^^^^^^^^^^^

This module provides the following imported targets, if found:

``pybind11::pybind11``
  The pybind11 (header only) library

Result Variables
^^^^^^^^^^^^^^^^

This will define the following variables:

``pybind11_FOUND``
  True if the system has the pybind11 library.
``pybind11_VERSION``
  The version of the pybind11 library which was found.

#]=======================================================================]

find_path(pybind11_INCLUDE_DIR
  NAMES pybind11/pybind11.h
  PATHS ${pybind11_ROOT}/include
  PATH_SUFFIXES pybind11
  NO_CACHE
)

# Example approach: parse the tail of pybind11_ROOT
# e.g. /path/to/felix_drivers/V1.2.3/x86_64 => pybind11_VERSION = V1.2.3
if(pybind11_ROOT)
  string(REGEX REPLACE "^.*/([^/]+).*$" "\\1" pybind11_VERSION "${pybind11_ROOT}")
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(pybind11
  FOUND_VAR pybind11_FOUND
  REQUIRED_VARS pybind11_INCLUDE_DIR
  VERSION_VAR pybind11_VERSION
)

if(pybind11_FOUND AND NOT TARGET pybind11::pybind11)
  add_library(pybind11::pybind11 INTERFACE IMPORTED)
  set_target_properties(pybind11::pybind11 PROPERTIES
    INTERFACE_INCLUDE_DIRECTORIES "${pybind11_INCLUDE_DIR}"
  )
endif()