#[=======================================================================[.rst:
Findsimdjson
-------------

Finds the simdjson library.

Imported Targets
^^^^^^^^^^^^^^^^

This module provides the following imported targets, if found:

``simdjson::simdjson``
  The simdjson library

Result Variables
^^^^^^^^^^^^^^^^

This will define the following variables:

``simdjson_FOUND``
  True if the system has the simdjson library.
``simdjson_VERSION``
  The version of the simdjson library which was found.

#]=======================================================================]

find_path(simdjson_INCLUDE_DIR
  NAMES simdjson.h
  PATHS ${simdjson_ROOT}/include
  PATH_SUFFIXES simdjson
  NO_CACHE
)
find_library(simdjson_LIBRARY
  NAMES simdjson
  PATHS ${simdjson_ROOT}/lib
  NO_CACHE
)

find_package(PkgConfig)
if(PKG_CONFIG_FOUND)
  set(ENV{PKG_CONFIG_PATH} "${simdjson_ROOT}/lib/pkgconfig:$ENV{PKG_CONFIG_PATH}")
  pkg_check_modules(PKG_SIMDJSON simdjson QUIET)
  if(PKG_SIMDJSON_FOUND)
    set(simdjson_VERSION "${PKG_SIMDJSON_VERSION}")
  endif()
endif()

# If not found via pkg-config, derive from the simdjson_ROOT path or any fallback
if(NOT simdjson_VERSION)
  # Example approach: parse the tail of simdjson_ROOT
  # e.g. /path/to/simdjson/V1.2.3/x86_64 => simdjson_VERSION = V1.2.3
  if(simdjson_ROOT)
    string(REGEX REPLACE "^.*/([^/]+)/[^/]+$" "\\1" simdjson_VERSION "${simdjson_ROOT}")
  endif()
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(simdjson
  FOUND_VAR simdjson_FOUND
  REQUIRED_VARS simdjson_LIBRARY simdjson_INCLUDE_DIR
  VERSION_VAR simdjson_VERSION
)

if(simdjson_FOUND AND NOT TARGET simdjson::simdjson)
  add_library(simdjson::simdjson SHARED IMPORTED)
  set_target_properties(simdjson::simdjson PROPERTIES
    IMPORTED_LOCATION "${simdjson_LIBRARY}"
    INTERFACE_INCLUDE_DIRECTORIES "${simdjson_INCLUDE_DIR}"
    IMPORTED_NO_SONAME TRUE
  )
endif()