function(felix_setup_options)
  if(PROJECT_IS_TOP_LEVEL)
    option(FELIX_ENABLE_COVERAGE "Enable coverage reporting" OFF)
    option(FELIX_ENABLE_IPO "Enable IPO/LTO" ON)
    option(FELIX_WARNINGS_AS_ERRORS "Treat Warnings As Errors" OFF)
    option(FELIX_ENABLE_SANITIZER_ADDRESS "Enable address sanitizer" OFF)
    option(FELIX_ENABLE_SANITIZER_LEAK "Enable leak sanitizer" OFF)
    option(FELIX_ENABLE_SANITIZER_UNDEFINED "Enable undefined sanitizer" OFF)
    option(FELIX_ENABLE_SANITIZER_THREAD "Enable thread sanitizer" OFF)
    option(FELIX_ENABLE_SANITIZER_MEMORY "Enable memory sanitizer" OFF)
    option(FELIX_ENABLE_CLANG_TIDY "Enable clang-tidy" OFF)
    option(FELIX_ENABLE_CPPCHECK "Enable cpp-check analysis" OFF)
    option(FELIX_INSTALL_RELEASE_ALL "Install all targets from not top level projects " OFF)
  endif()
  option(${PROJECT_NAME}_ENABLE_ERS_DEBUG "Compile with ERS DEBUG messages on" OFF)

  if(NOT PROJECT_IS_TOP_LEVEL)
    mark_as_advanced(${PROJECT_NAME}_ENABLE_ERS_DEBUG)
  endif()
endfunction()

macro(felix_global_options)
  if(FELIX_ENABLE_IPO)
    include(InterproceduralOptimization)
    felix_enable_ipo()
  endif()
endmacro()

macro(felix_local_options)
  if(PROJECT_IS_TOP_LEVEL)
    include(StandardProjectSettings)
  endif()

  add_library(${PROJECT_NAME}_warnings INTERFACE)
  add_library(${PROJECT_NAME}_options INTERFACE)

  include(CompilerWarnings)
  set(FELIX_PRESET_MSVC_WARNINGS "")
  felix_set_project_warnings(
    ${PROJECT_NAME}_warnings
    ${FELIX_WARNINGS_AS_ERRORS}
    "${FELIX_PRESET_MSVC_WARNINGS}"
    "${FELIX_PRESET_CLANG_WARNINGS}"
    "${FELIX_PRESET_GCC_WARNINGS}"
    "${FELIX_PRESET_CUDA_WARNINGS}")

  include(Sanitizers)
  felix_enable_sanitizers(
    ${PROJECT_NAME}_options
    ${FELIX_ENABLE_SANITIZER_ADDRESS}
    ${FELIX_ENABLE_SANITIZER_LEAK}
    ${FELIX_ENABLE_SANITIZER_UNDEFINED}
    ${FELIX_ENABLE_SANITIZER_THREAD}
    ${FELIX_ENABLE_SANITIZER_MEMORY})

  include(StaticAnalyzers)
  if(FELIX_ENABLE_CLANG_TIDY)
    felix_enable_clang_tidy(${PROJECT_NAME}_options ${FELIX_WARNINGS_AS_ERRORS})
  endif()

  if(FELIX_ENABLE_CPPCHECK)
    felix_enable_cppcheck(${FELIX_WARNINGS_AS_ERRORS} "" # override cppcheck options
    )
  endif()

  if(FELIX_ENABLE_COVERAGE)
    include(Tests)
    felix_enable_coverage(${PROJECT_NAME}_options)
  endif()

  # FELIX stuff
  target_compile_definitions(${PROJECT_NAME}_options INTERFACE
    -DREGMAP_VERSION=$ENV{REGMAP_VERSION})

  # Debug symbols
  if (CMAKE_BUILD_TYPE STREQUAL "Release")
    target_compile_options(${PROJECT_NAME}_options INTERFACE -g)
  endif()

  # ERS
  remove_definitions(-DERS_NO_DEBUG)
  if(NOT ${PROJECT_NAME}_ENABLE_ERS_DEBUG)
    target_compile_definitions(${PROJECT_NAME}_options INTERFACE -DERS_NO_DEBUG)
  endif()
endmacro()
