# FELIX distribution documentation

## Introduction

The FELIX software is split up into projects, each with its own git repository. The full FELIX software distribution is contained in the felix-distribution project which contains a file speciying all versions to be used. It can be used to work and make changes across multiple projects by using the `scripts/setup_local_work_area.py` script which clones all projects and configures CMake to use them instead of the reference version.

## New documentation

Find the new documentation [here](https://atlas-project-felix.web.cern.ch/atlas-project-felix/public/code-docs/felix-distribution/5.2.x/).

**Current supported configuration:**
`x86_64-el9-gcc13-opt` (AlmaLinux9, RHEL9)

## How to build felix-distribution

* Clone this repository

  ```
  git clone felix-distribution
  cd felix-distribution
  ```
  > By default the master branch of felix-distribution is cloned. To change branch now run `git checkout <name of desired branch>`

* Populate submodules

  ```
  git submodule init
  git submodule update
  ```

* Prepare the environment

  ```
  source python_env/bin/activate
  source cmake_tdaq/bin/setup.sh
  ```
  > By default Phase-II firmware (rm-5.X.Y) is assumed. To compile software for Phase-I (rm-4.X.Y) firmware now run: `export REGMAP_VERSION=0x0400`

* Optional: Setup projects locally

  If you want to make changes to packages locally run
  ```
    ```bash
  ./scripts/setup_local_work_area.py
  ```
  ```
  > This clones all modules into felix-distribution and sets up CMake to use those. You can make changes locally and felix-distribution will be compiled aginst them.

* Compile
  ```
  cmake_config
  cd x86_64-el9-gcc13-opt
  make -j8
  ```

### Advanced setups

* Compile against a custom branch/tag of module
  ```cmake
  # In CMakeLists before `felix_add_dependency`
  set(my_dependency_tag "my-branch/my-commit")
  ```
  > The name of the variable is the name of the module with underscores instead of hyphens plus `_tag`

* Compile against a local version of a module
  ```
  cmake_config -- -DCPM_my-dependency_SOURCE=/path/to/dependency
  ```
  > Use the `scripts/setup_local_work_area.py` script if you want to clone all modules to work locally (see above). The variable name is `CPM_` + the name of your dependency (as is e.g. felix-star or hdlc_coder) + `_SOURCE`. Run `-DCPM_my-dependency_SOURCE=` if you no longer want to compile against the local clone.

To set up FELIX software in another session, after the first compilation:
```
source felix-distribution/setup.sh
```

## Building a release tar
Run the package target, e.g.
```
make package
```

## Running CI tests locally

CI tests use the CTest framework provided by CMake.
[Having built felix-distribution](#how-to-build-felix-distribution), CI tests are run with:
```
ctest -R <regular expression for test name> -j <number of tests in parallel e.g. 6>
```
This is meant only for developers as some tests require a certain hardware configuration.

## Developing individual projects

If you wish to develop an individual project independently, the clone and build procedure is the same as for felix-distribution, as shown below taking as example `felix-star`.

    git clone felix-star
    cd felix-star
    git submodule init
    git submodule update
    source python_env/bin/activate
    source cmake_tdaq/bin/setup.sh
    cmake_config
    cd x86_64-el9-gcc13-opt
    make -j8

## Updating submodules

If running with locally cloned projects, use `git` to pull

    cd <project>
    git checkout master
    git pull
    cd ..

    # try to build and test in x86_64-el9-gcc13-opt

    git add -p  # Validate changes
    git commit  # Provide which project was updated in the title and a summary of changes in the body


Otherwise

    ./update.py
    git add -p  # Validate changes
    git commit  # Provide which project was updated in the title and output of the script in the body


## Listing of current projects

#### cmake_tdaq

General module to setup for compilation and generate the proper makefiles from cmake. This module contains the versions of all LCG and external modules to be used in cmake_tdaq/cmake/modules/FELIX-versions.cmake.

#### elinkconfig

GUI to setup elinks. Reads or writes a felix device and reads or writes elink configuration files. These files can also be used with the feconf utility from the ftools project.

#### felig-tools

Tools to control the felig (generator) on a felix device.

#### felix-bus-fs

Second generation bus which uses the filesystem for communication. In use by felix-star as of version 4.2.

#### felix-client

Client to felixbus-fs and netio-next implementing felix-interface.

#### felix-client-thread

Implementation of client which searches for the shared library of felix-client and its dependencies and loads it. A similar module exists in the TDAQ. They can this way just put a felix-client in their LD_LIBRARY_PATH and find that one, independent of the version, as long as the felix-interface has not changed. This module also contains the felix_client_thread_extension which contains methods not yet in the public interface.

#### felix-def

All cross-project definitions in C, C++ and python for FELIX. Includes ports, elinks, and conversions of fids.

#### felix-interface

The actual interface for felix-client. This module is shared with TDAQ. It contains the actual interface. For any new, but not published, methods for the next version, see felix-client-thread. The latter methods can be used by FELIX itself, just not by the TDAQ until they are published.

#### felix-release-notes

Utility to extract ReleaseNotes from JIRA into html format. Used by the FELIX website and to make the release.

#### felix-star

Event-driven, single-threaded, readout application. Replaces felixcore.

#### felix-tag

Module to inject the same version number in all of the programs that depend on this module.

#### felix-unit-test

Unit tests support in Python and C++ to support running tests using supervisord.

#### flxcard

API and low-level tools for the FELIX card.

### flxcard_py

Python interface to flxcard.

#### ftools

High level tools for the FELIX card.

#### hdlc_coder

Module to handle HDLC encoding and decoding (parts that are not in the firmware).

#### netio-next

Event-driven RDMA communication library. Replaces netio.

#### netio3

Event-driven RDMA/TCP communication library. Replaces netio-next.

#### netio3-backend

Network backend for netio3.

#### python_env

Python environment for FELIX. Assumes a proper python3 version is picked up from LCG. All extra libraries are installed here.

#### regmap

Register map generated code. Uses wuppercodegen and registermaps in the firmware repository to create C header files.

#### wuppercodegen

Tool to generate VHDL, C code, HTML and LaTeX documentation from a single Yaml registermap file.

## Listing of External Modules

All the external libraries and tools to be used by FELIX. No branches here, but different versions on 'master'. Binaries and Libraries are checked into git for these modules.

#### external/catch

Testing framework for C++.

#### external/docopt

C++ version of docopt command line parsing.

#### external/json

Json reader and writer in C++.

#### external/libfabric

RDMA support for mellanox cards. Used by netio and netio-next.

#### external/libnuma

Numa support for applications.

#### external/pybind11

Python binding for C++ libraries.

#### external/simdjson

Very fast json reader in C.

#### external/yaml-cpp

Yaml parser in C++.
