# FELIX-IO

The felix-io package provide read (and write) access to the bitfields of the registermap and i2c components of the FELIX cards.
The package consists of three modules:

1. [felix-io-api](https://gitlab.cern.ch/atlas-tdaq-felix/felix-io-api): the interface in the form of an API
2. [felix-io](https://gitlab.cern.ch/atlas-tdaq-felix/felix-io): the server implementation in python in the form of a FASTAPI webserver connected to one or more felix cards
3. [felix-io-client](https://gitlab.cern.ch/atlas-tdaq-felix/felix-io-client): a Python and C++ client to call the api

# FELIX-IO-API (web)

The following URLs are available for either devices (d) or cards (c). Translation from cards to devices is done using the setup in the machine, which depends on the cards installed.

Urls may be followed by the following query parameters:

- __?info=True__: which results in an added 'info' dictionary providing information about the bitfield.

Results of requests are encoded in json. Except for the top-level api request, which provides a list of cards and devices, all other requests provide a dictionary of bitfields (by name). Each __bitfields__ contains:

- __value__: the actual value in int, float or string format, or list of int, float or string
- __unit__: _optional_ unit in string format
- __decoded_value__: the actual value in string format, including an optional unit if available, or list of string
- __raw_value__: _optional_ the original value in int or list of int format if it is different from value
- __info__: _optional_ extra info on the bitfield (conversion, width, ...)


## data [GET]

__Bitfields__ can be read by name.

__I2C requests__ need both a devicename and registername. These are encoded as **{device_name}:{register_name}**

__Aliases__ are defined in the registermaps (regular and i2c) for bitfields across the system. An fpga_temperature (alias) may be defined for i2c (chip depends on the felixcard) and in the regular registermap. When reading an alias i2c takes precedence over regular registermap.

__Groups__ are lists of bitfields, i2c bitfields and aliases. These are defined in the regular and i2c register maps.

Bitfields, aliases and groups have simple names. Bitfields tend to be fully upppercase, while aliases and groups are lowercase or capitalized. I2C names have a colon to separate device_name, normally fully uppercase, from the register_name, normally fully lowercase.

A __generic__ read of **device/{n}/{name}** will first check for bitfields in the regular registermap, then for i2c bitfields, followed by alias and finally group.

__Generic__ access:

- [http://127.0.0.1:51960/**api**](http://127.0.0.1:51960/api) -> list of devices and card info for this machine
- [http://127.0.0.1:51960/api/**device/{n}/{name}**](http://127.0.0.1:51960/api/device/{n}/{name}) -> read bitfield, i2c bitfield, alias or group

__Specific__ access:

- [http://127.0.0.1:51960/api/**device/{n}/bitfield/{name}**](http://127.0.0.1:51960/api/device/{n}/bitfield/{name}) -> read regmap bitfield
- [http://127.0.0.1:51960/api/**device/{n}/i2c/{name}**](http://127.0.0.1:51960/api/device/{n}/i2c/{name}) -> read i2c bitfield name in format {device_name}:{register_name}
- [http://127.0.0.1:51960/api/**device/{n}/alias/{name}**](http://127.0.0.1:51960/api/device/{n}/alias/{name}) -> read aliased i2c bitfield or regmap bitfield
- [http://127.0.0.1:51960/api/**device/{n}/group/{name}**](http://127.0.0.1:51960/api/device/{n}/group/{name}) -> read group of bitfields, i2c bitfields and aliases

__Card__ access:

- [http://127.0.0.1:51960/api/**card/{n}/{name}**](http://127.0.0.1:51960/api/card/{n}/{name}) -> read bitfield, i2c bitfield, alias or group from a card (which translates to a device)

## data [POST]

A user defined list of bitfields, i2c bitfields, aliases and groups can be posted and read in one go.

- [http://127.0.0.1:51960/api/**device{n}**](http://127.0.0.1:51960/api/d{n}) + POSTED list of bitfields, i2c bitfields, aliases and groups

## data [PUT]

A regular bitfield may be written using:

- [http://127.0.0.1:51960/api/**device/{n}/bitfield/{name}?value={value}**](http://127.0.0.1:51960/api/device/{n}/bitfield/{name}?value={value}) -> write regular bitfield with value
