# FELIX-IO

The felix-io package provide read (and write) access to the bitfields of the registermap and i2c components of the FELIX cards.
The package consists of three modules:

1. [felix-io-api](https://gitlab.cern.ch/atlas-tdaq-felix/felix-io-api): the interface in the form of an API
2. [felix-io](https://gitlab.cern.ch/atlas-tdaq-felix/felix-io): the server implementation in python in the form of a FASTAPI webserver connected to one or more felix cards
3. [felix-io-client](https://gitlab.cern.ch/atlas-tdaq-felix/felix-io-client): a Python and C++ client to call the api

# FELIX-IO

Use the default mechanism to compile from source:

```
git clone ssh://git@gitlab.cern.ch:7999/atlas-tdaq-felix/felix-io.git
cd felix-io
. setup.sh
cmake_config
cd x86_64-el9-gcc15-opt
make -j 8
pytest -vv
```

The felix-io FASTAPI server can be started with:

```./felix-io.py```

on the local machine.

```
Usage:
    felix-io.py [options]

Options:
    -p, --port <PORT>           Port for server [default: 51960]
    -h, --host <IP>             IP name to bind to [default: 0.0.0.0]
    -c, --cache <TIME>          Cache time for i2c requests in seconds [default: 5], use 0 for no caching
    -s, --simulate              Use simulated values, does not connect to FELIX cards
    -l, --log-level LEVEL       Use logging level (ERROR, INFO, DEBUG, TRACE) [default: INFO]
    -v, --verbose               Run in verbose mode
    -d, --debug                 Run in debug mode
    -h, --help                  Show this help
    --clear-registers           Clear latched registers
```
