{% include 'functions.js' %}

new DataTable('#table', {
    ajax: {
        url: '{{ ajax_url }}'
        {% if ajax_data is defined and ajax_data is not none %}
        , type: 'POST'
        , contentType: 'application/json'
        , data: function (d) {
            d = {{ ajax_data|safe }};
            return JSON.stringify(d);
        }
        {% endif %}
    },
    layout: {
        topStart: {
            buttons: [
                {
                    extend: 'colvis',
                    columns: ':not(.noVis)',
                    popoverTitle: 'Column visibility selector'
                }
            ]
        }
    },
    columns: [
        { data: 'name', className: 'monospaced noVis' },
        { data: 'desc', className: 'word-wrapped', render: description },
        { data: 'address', className: 'monospaced', render: address },
        { data: 'alias', className: 'monospaced', render: value, visible: false },
        { data: 'group', className: 'monospaced', render: value, visible: false },
        { data: 'convert', className: 'monospaced', render: value, visible: false },
        { data: 'power', className: 'monospaced', render: value, visible: false },
        { data: 'multiply', className: 'monospaced', render: value, visible: false },
        { data: 'divide', className: 'monospaced', render: value, visible: false },
        { data: 'offset', className: 'monospaced', render: value, visible: false },
        { data: 'unit', className: 'monospaced', render: value, visible: false },
        { data: 'clear', className: 'monospaced', render: value, visible: false },
        { data: 'mask', className: 'monospaced', render: mask, visible: false },
        { data: 'bf_hi', className: 'monospaced', render: bf_hi, visible: false },
        { data: 'bf_lo', className: 'monospaced', render: bf_lo, visible: false },
        { data: 'write', className: 'monospaced', render: write, visible: false },
        { data: 'value', className: 'monospaced', render: display_value },
        { data: 'raw_value', className: 'monospaced', render: value, visible: false },
        { data: 'decoded_value', className: 'monospaced', render: value }
    ],
    {% include 'table_properties.js' %}
});
