function decimalToHex(d, padding) {
    var hex = BigInt(d).toString(16);
    padding = typeof (padding) === "undefined" || padding === null ? padding = 2 : padding;

    while (hex.length < padding) {
        hex = "0" + hex;
    }

    hex = "0x" + hex;

    return hex;
}

function bitsToHex(d, bf_hi=0, bf_lo=0) {
    return bf_hi > 0 ? decimalToHex(d, (bf_hi - bf_lo + 1)/4) : decimalToHex(d)
}

function description(data, _type, _row) {
    return data.split("\n").join("<br/>");
}

function address(data, _type, _row) {
    return bitsToHex(data);
}

function mask(data, _type, _row) {
    return bitsToHex(data, 63);
}

function bf_hi(data, _type, _row) {
    return data;
}

function bf_lo(data, _type, _row) {
    return data
}

function write(_data, _type, row) {
    return row.type.includes('REGMAP_REG_TRIGGER') ? "T" : row.type.includes('REGMAP_REG_WRITE') ? "W" : "R";
}

const use_hex = [
    'BOARD_ID_TIMESTAMP',
    'GIT_COMMIT_TIME',
    'GIT_TAG',
    'REG_MAP_VERSION',
    'STATUS_LEDS'
]

function display_value(data, _type, row) {
    return use_hex.includes(row.name) ? bitsToHex(row.raw_value) : data;
}

function value(data, _type, _row) {
    return data;
}
