#!/usr/bin/env python3
import concurrent.futures
import subprocess
import unittest
import os
from time import sleep
from felix_test_case import FelixTestCase


class TestContinuousLoopbackBuffered(FelixTestCase):

    def setUp(self):
        self.start('loopback-buffered-' + FelixTestCase.netio_protocol)

    def tearDown(self):
        self.stop('loopback-buffered-' + FelixTestCase.netio_protocol)

    def run_resend_continuous_loopback_buffered(self):
        sleep(5)
        self.stop('loopback-buffered-' + FelixTestCase.netio_protocol)
        sleep(10)
        self.start('loopback-buffered-' + FelixTestCase.netio_protocol)

    def run_subscribe_continuous_loopback_buffered(self):
        try:
            print("starting\n")
            timeout = 60
            ip = FelixTestCase.ip
            fid = FelixTestCase.fid
            fid_toflx = FelixTestCase.fid_toflx
            bus_dir = FelixTestCase.tmp_prefix + '-bus'
            group_name = "FELIX_CLIENT_" + FelixTestCase.uuid
            event_loop = "--use-asio-eventloop" if FelixTestCase.netio_eventloop == "asio" else ""
            self.wait_file(os.path.join(bus_dir, group_name), timeout)
            subprocess.check_output(' '.join(("./felix-client-thread-continuous-loopback",
                                              event_loop,
                                              "--bus-dir", bus_dir,
                                              "--bus-group-name", group_name, ip, fid, fid_toflx,
                                              "--timeout", "5000",
                                              "\"Hello FELIX\"")),
                                    timeout=timeout, stderr=subprocess.STDOUT, shell=True, encoding="utf-8")
        except subprocess.CalledProcessError as e:
            print(e.returncode)
            print(e.cmd)
            print(e.output)
            self.assertEqual(e.returncode, 42)
        except subprocess.TimeoutExpired as e:
            print(e.cmd)
            if e.output:
                print(e.output.decode())
            print("Timeout !")
            self.assertTrue(False)

    def test_send_continuous_loopback_buffered(self):
        task_set = {}
        executor = concurrent.futures.ThreadPoolExecutor(max_workers=2)
        a = executor.submit(self.run_subscribe_continuous_loopback_buffered)
        task_set[a] = "subscribe"
        b = executor.submit(self.run_resend_continuous_loopback_buffered)
        task_set[b] = "resend"

        for task in concurrent.futures.as_completed(task_set.keys()):
            print("result " + task_set[task] + " " + str(task.result()))


if __name__ == '__main__':
    unittest.main()
