#!/usr/bin/env python3

import subprocess
import unittest
import os

from felix_test_case import FelixTestCase


class TestReceiveSendTimeout(FelixTestCase):

    def setUp(self):
        self.start('receive-buffered-' + FelixTestCase.netio_protocol)

    def tearDown(self):
        self.stop('receive-buffered-' + FelixTestCase.netio_protocol)

    def test_thread_send_buffered(self):
        try:
            timeout = 30
            ip = FelixTestCase.ip
            fid_toflx = FelixTestCase.fid_toflx
            bus_dir = FelixTestCase.tmp_prefix + '-bus'
            group_name = "FELIX_CLIENT_" + FelixTestCase.uuid
            event_loop = "--use-asio-eventloop" if FelixTestCase.netio_eventloop == "asio" else ""
            self.wait_file(os.path.join(bus_dir, group_name), timeout)
            message = "A" * (64 * 1024 + 1)  # Create a message that is too big
            subprocess.check_output(' '.join(("./felix-client-thread-send",
                                              event_loop,
                                              "--verbose",
                                              "--bus-dir", bus_dir,
                                              "--bus-group-name", group_name,
                                              "--timeout", "1000",
                                              ip, fid_toflx, message)),
                                    timeout=timeout, stderr=subprocess.STDOUT, shell=True, encoding="UTF-8")
            # print(output)
        except subprocess.CalledProcessError as e:
            print(e.returncode)
            print(e.cmd)
            print(e.output)
            self.assertEqual(e.returncode, 4)
        except subprocess.TimeoutExpired as e:
            print(e.cmd)
            if e.output:
                print(e.output.decode())
            print("Timeout !")
            self.assertTrue(False)


if __name__ == '__main__':
    unittest.main()
