#pragma once

#include <functional>
#include <map>
#include <string>
#include <memory>

class FelixClientThreadInterface {

public:
    typedef std::function<void (uint64_t fid, const uint8_t* data, size_t size, uint8_t status)> OnDataCallback;
    typedef std::function<void ()> OnInitCallback;
    typedef std::function<void (uint64_t fid)> OnConnectCallback;
    typedef std::function<void (uint64_t fid)> OnDisconnectCallback;
    typedef std::function<void ()> OnUserTimerCallback;
    typedef std::function<void ()> UserFunction;

    typedef std::map<std::string, std::string> Properties;

    struct Config {
        OnDataCallback on_data_callback;
        OnInitCallback on_init_callback;
        OnConnectCallback on_connect_callback;
        OnDisconnectCallback on_disconnect_callback;
        Properties property;
    };

    virtual ~FelixClientThreadInterface() {};

    virtual void send_data(uint64_t fid, const uint8_t* data, size_t size, bool flush) = 0;

    virtual void subscribe(uint64_t fid) = 0;
    virtual void unsubscribe(uint64_t fid) = 0;

    virtual void exec(const UserFunction &user_function) = 0;
};
