#pragma once

#include <memory>
#include <string>
#include <vector>

#include "felix/felix_client_thread_extension.hpp"

class FelixClientThreadExtension42 : public FelixClientThreadExtension {

public:
    virtual ~FelixClientThreadExtension42() {};

    virtual Status send_cmd(const std::vector<uint64_t>& fids, Cmd cmd, const std::vector<std::string>& cmd_args, std::vector<Reply>& replies) = 0;

    virtual void subscribe(const std::vector<uint64_t>& fids) = 0;

    /* Defined in felix_client_thread_interface and redone here to avoid warning of gcc13 */
    virtual void subscribe(uint64_t fid) override = 0;
};
