#pragma once

#include <memory>

#include "felix/felix_client_thread_interface.hpp"

class FelixClientThreadExtension : public FelixClientThreadInterface {

public:
    virtual ~FelixClientThreadExtension() {};

    virtual void init_send_data(uint64_t fid) = 0;
    virtual void init_subscribe(uint64_t fid) = 0;

    // for felix-register
    enum Cmd {
        UNKNOWN = 0,
        NOOP = 1,
        GET = 2,
        SET = 3,
        TRIGGER = 4,
        ECR_RESET = 5
    };

    enum Status {
        OK = 0,
        ERROR = 1,
        ERROR_NO_SUBSCRIPTION = 2,
        ERROR_NO_CONNECTION = 3,
        ERROR_NO_REPLY = 4,
        ERROR_INVALID_CMD = 5,
        ERROR_INVALID_ARGS = 6,
        ERROR_INVALID_REGISTER = 7,
        ERROR_NOT_AUTHORIZED = 8
    };

    struct Reply {
        uint64_t ctrl_fid;
        Status status;
        uint64_t value;
        std::string message;
    };
};
