#pragma once

#include <memory>
#include <string>
#include <vector>

#include "felix/felix_client_thread_extension.hpp"

class FelixClientThreadExtension421 : public FelixClientThreadExtension42 {

public:
    virtual ~FelixClientThreadExtension421() {};

    virtual void send_data(uint64_t fid, const std::vector<const uint8_t*>& msgs, const std::vector<size_t>& sizes) = 0;

    /* Defined in felix_client_thread_interface and redone here to avoid warning of gcc13 */
    virtual void send_data(uint64_t fid, const uint8_t* data, size_t size, bool flush) override = 0;
};
