--------------------------------------------------------------------------------
-- Company: 
-- Engineer:
--
-- Create Date:   10:56:19 05/08/2008
-- Design Name:   
-- Module Name:   UART_led_full_tb.vhd
-- Project Name:  LabFlow
-- Target Device:  
-- Tool versions:  
-- Description:   
-- 
-- VHDL Test Bench Created by ISE for module: FPGAFlowDesign
-- 
-- Dependencies:
-- 
-- Revision:
--
------------------------------------------------------------------------------------
--
--  Disclaimer: LIMITED WARRANTY AND DISCLAMER. These designs are
--              provided to you "as is". Xilinx and its licensors make, and you
--              receive no warranties or conditions, express, implied,
--              statutory or otherwise, and Xilinx specifically disclaims any
--              implied warranties of merchantability, non-infringement, or
--              fitness for a particular purpose. Xilinx does not warrant that
--              the functions contained in these designs will meet your
--              requirements, or that the operation of these designs will be
--              uninterrupted or error free, or that defects in the Designs
--              will be corrected. Furthermore, Xilinx does not warrant or
--              make any representations regarding use or the results of the
--              use of the designs in terms of correctness, accuracy,
--              reliability, or otherwise.
--
--              LIMITATION OF LIABILITY. In no event will Xilinx or its
--              licensors be liable for any loss of data, lost profits, cost
--              or procurement of substitute goods or services, or for any
--              special, incidental, consequential, or indirect damages
--              arising from the use or operation of the designs or
--              accompanying documentation, however caused and on any theory
--              of liability. This limitation will apply even if Xilinx
--              has been advised of the possibility of such damage. This
--              limitation shall apply not-withstanding the failure of the
--              essential purpose of any limited remedies herein.
--
--  Copyright  2002, 2008 Xilinx, Inc.
--  All rights reserved
--
------------------------------------------------------------------------------------
--
-- Revision 0.01 - File Created
-- Additional Comments:
--
-- Notes: 
-- This testbench has been automatically generated using types std_logic and
-- std_logic_vector for the ports of the unit under test.  Xilinx recommends
-- that these types always be used for the top-level I/O of a design in order
-- to guarantee that the testbench will bind correctly to the post-implementation 
-- simulation model.
--------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL;
USE ieee.math_real.all;

library utilities_lib;
use utilities_lib.time_utilities_pkg.all;
use utilities_lib.string_utilities_synth_pkg.all;

library specific_support_lib;
use specific_support_lib.tb_fifo_pkg.all;

 
ENTITY UART_led_full_tb IS
     Generic (CLOCK_RATE       : integer := 100_000_000;              -- clock rate
              BAUD_RATE        : integer :=     115_200               -- desired baud rate
              );
END UART_led_full_tb;


ARCHITECTURE behavior OF UART_led_full_tb IS 
 
        -- Component Declaration for the Unit Under Test (UUT)
--       component uart_rx is
--          generic (
--                   BAUD_RATE   : integer :=     115_200;              -- serves as clock divisor
--                   CLOCK_RATE  : integer := 100_000_000               -- freq of clk
--                );
--           Port ( rst_clk_rx         : in  STD_LOGIC;
--                  clk_rx             : in  STD_LOGIC;
--                  rxd_i              : in  STD_LOGIC;
--                  rx_data            : out STD_LOGIC_VECTOR (7 downto 0);
--                  rx_data_rdy        : out STD_LOGIC;
--                  frm_err            : out STD_LOGIC
--                 );
--       END component uart_rx;
       
       component uart_led is
            Generic (CLOCK_RATE : integer := 50_000_000;
                     BAUD_RATE  : integer :=    115_200
                    );
           Port ( clk_pin       : in  STD_LOGIC;
                  rst_pin       : in  STD_LOGIC;
                  rxd_pin       : in  STD_LOGIC;
                  sel_pin       : in  STD_LOGIC;
                  led_pins      : out STD_LOGIC_VECTOR (7 downto 0)
                );
       end component uart_led;
       
       component tb_uart_driver is
          generic ( 
                MESSAGE    : String := "default";
                BIT_PERIOD : time := 10 ns 
            );
          port ( 
             rst_clk_rx        : in  std_logic;
             data_sent         : out std_logic;
             data_to_send      : out std_logic_vector(7 downto 0);
             data_out_serial   : out std_logic
            );          
       end component tb_uart_driver;  
       
       component tb_resp_checker is
        port (  data_to_send   : in  STD_LOGIC_VECTOR(7 downto 0);
                data_sent      : in  STD_LOGIC;
                rx_data        : in  STD_LOGIC_VECTOR (7 downto 0);
                frm_err        : in  STD_LOGIC;
                rx_data_rdy    : in  STD_LOGIC
              );
       end component tb_resp_checker;  
        

       -- System signals
       signal clk_rx              : std_logic := 'U';
       signal rst_clk_rx          : std_logic := 'U';
       
       -- Internal data signals
       signal frm_err             : std_logic := 'U';
       signal data_to_send        : std_logic_vector(7 downto 0) := (others=>'U');
       signal delayed_data_to_send: std_logic_vector(7 downto 0) := (others=>'U');
       signal data_sent           : std_logic := 'U';
       signal rxd_clk_rx          : std_logic := 'U';
       signal rx_data             : std_logic_vector(7 downto 0) := (others=>'U');   -- from output of FIFO to the data checker
       signal rx_data_rdy         : std_logic := 'U';                                -- indicates that data is valid from the UART rx
       
       -- FIFO to manage data 
       --signal data_fifo            : FIFO_TYPE := (width=>8, depth=>256, read_ptr=>0, write_ptr=>0, volume=>0, empty=>true, full=>false, contents=>(others=>(others=>'0')));
       

       -- Clock period definitions
       constant CLK_RX_PERIOD     : time := 10 ns;
       --constant CLK_RX_PERIOD   : time := 1.0 sec / real(CLOCK_RATE);     -- test! and use instead of line above
       constant BIT_PERIOD        : time := 1.0 sec / real(BAUD_RATE);
       
       signal   preferred_units   : string (1 to 3) := "ns ";
       signal gnd : std_logic_vector(7 downto 0) := (others=> '0');   
              
       signal new_data_present : std_logic := 'U';
       signal last_datum : std_logic_vector(7 downto 0) := (others => 'U');
          
 
    BEGIN
    
       -- welcome message
       welcome: process
          begin
             writeNowToScreen("Starting the testbench for the receiver portion of the UART!");
             writeNowToScreen("BAUD_RATE = "&integer'IMAGE(BAUD_RATE));     
             writeNowToScreen("BIT_PERIOD = "&TIME'IMAGE(BIT_PERIOD));   -- doesn't work as expected            
             wait;
          end process welcome;

       -- generate the clk_rx signal
       gen_clk_rx: process
          begin
             clk_rx <= '0';
             wait for CLK_RX_PERIOD/2;
             clk_rx <= '1';
             wait for CLK_RX_PERIOD/2;
          end process;
 
       -- reset process
       reset_proc: process
             variable temp_fifo : FIFO_TYPE;
          begin
             -- hold reset active for 100 rising edges of the clock
             writeNowToScreen("Asserting reset for 100 clock cycles");
             rst_clk_rx <= '1';
             rst_delay: for i in 1 to 100 loop
                wait until rising_edge(clk_rx);
             end loop;
             
             -- remove the reset and begin normal operation
             writeNowToScreen(String'("Deasserting reset"));
             rst_clk_rx <= '0';
             wait;
          end process reset_proc;
          
          
       -- Instantiate the data generator - uses the predefined character sequence and transmits bit-by-bit
       tb_uart_driver_i0: tb_uart_driver 
          generic map (BIT_PERIOD => BIT_PERIOD, MESSAGE => "Welcome to Xilinx Designing with VHDL")
          port map (  rst_clk_rx        => rst_clk_rx,
                      data_to_send      => data_to_send,
                      data_sent         => data_sent,
                      data_out_serial   => rxd_clk_rx
                     );
    
  
       -- Instantiate the data checker
       tb_resp_checker_i0: tb_resp_checker
           port map (data_to_send    => data_to_send,
                     data_sent       => data_sent,
                     rx_data         => rx_data,
                     frm_err         => gnd(0),
                     rx_data_rdy     => new_data_present
                    );

--       -- Instantiate the unit under test 
--       uart_rx_i0: uart_rx
--          generic map (
--                   BAUD_RATE   =>  BAUD_RATE,
--                   CLOCK_RATE  => CLOCK_RATE              -- freq of clk
--                )
--           Port map ( rst_clk_rx     => rst_clk_rx,
--                      clk_rx         => clk_rx,
--                      rxd_i          => rxd_clk_rx,
--                      rx_data        => rx_data,
--                      rx_data_rdy    => rx_data_rdy,
--                      frm_err        => frm_err
--                    );

            UUT: uart_led
             generic map (CLOCK_RATE => CLOCK_RATE,
                          BAUD_RATE  =>    BAUD_RATE
                         )
             Port map ( clk_pin => clk_rx,
                   rst_pin     => rst_clk_rx,
                   rxd_pin     => rxd_clk_rx,
                   sel_pin     => gnd(0),
                   led_pins    => rx_data
                 );
                 
                -- Combinatorial solution to provide the response checker with a one clock period pulse to indicate new data
                 new_data_present <= '1' when (last_datum /= rx_data) else '0'; -- when data changes then assert new_data_present
                 last_datum <= rx_data when rising_edge(clk_rx);                -- register to create a one clock delay
                 
                 -- sequential solution to provide the response checker with a one clock period pulse to indicate new data
             --    mkDataAvail: process(clk_rx)
             --        variable last_datum : std_logic_vector(7 downto 0) := (others=>'U');        
             --    begin
             --        if rising_edge(clk_rx) then
             --            if (rx_data /= last_datum) then
             --                new_data_present <= '1';
             --            else
             --                new_data_present <= '0';
             --            end if;
             --            last_datum := rx_data;    
             --        end if;
             --    end process mkDataAvail;      

    END;

